function CreateArmyBridges()
	UACounter = UACounter + 1
	UAP8Attack = LazyUnlimitedArmy:New({
		Player = 8,
		Area = 3500,
		AutoDestroyIfEmpty = false,
		TransitAttackMove = true,
		Formation = UnlimitedArmy.Formations.Chaotic,
		PrepDefense = false,
		DestroyBridges = false,
		LeaderFormation = 4,
		AIActive = true,
		DefendDoNotHelpHeroes = false,
		DoNotNormalizeSpeed = false,
		IgnoreFleeing = true,
		HiResJob = true
	},
	UACounter,
	UAMaxCounter
	)
	UAP8Attack.CurrentBridge = 0
	UAP8AttackRecuiter = UnlimitedArmyRecruiter:New(UAP8Attack,{
		Buildings = BuildingTable,
		ArmySize = 15,
		UCats = {
			{UCat = UpgradeCategories.LeaderSword, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.LeaderPoleArm, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.LeaderBow, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.LeaderHeavyCavalry, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.LeaderCavalry, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.Cannon4, SpawnNum = 1, Looped = true},
			{UCat = UpgradeCategories.LeaderRifle, SpawnNum = 1, Looped = true},
		},
		ResCheat = true,
		ReorderAllowed = false,
		RemoveUnavailable = true,
		RandomizeSpawn = true,
		DoNotRemoveIfDeadOrEmpty = true,
	})
	UAP8Attack:AddCommandMove(GetPosition("ArmyMovePos0"),true)
	UAP8Attack:AddCommandWaitForSpawnerFull(true)
	UAP8Attack:AddCommandSetSpawnerStatus(false,true)
	UAP8Attack:AddCommandLuaFunc(CheckNextBridgeUA,true)
	UAP8Attack:AddCommandMove(GetPosition("ArmyMovePos1"),true)
	UAP8Attack:AddCommandLuaFunc(CheckNextBridgeUA,true)
	UAP8Attack:AddCommandMove(GetPosition("ArmyMovePos2"),true)
	UAP8Attack:AddCommandLuaFunc(CheckNextBridgeUA,true)
	UAP8Attack:AddCommandMove(GetPosition("ArmyMovePos3"),true)
	UAP8Attack:AddCommandLuaFunc(CheckNextBridgeUA,true)
	UAP8Attack:AddCommandMove(GetPosition("ArmyMovePos4"),true)
	UAP8Attack:AddCommandLuaFunc(CheckNextBridgeUA,true)
	UAP8Attack:AddCommandMove(GetPosition("ArmyMovePos5"),true)
	UAP8Attack:AddCommandWaitForIdle(true)
	UAP8Attack:AddCommandMove(GetPosition("lastarmybridgePoint"),true)
	UAP8Attack:AddCommandWaitForTroopSize(1,true,true)
	UAP8Attack:AddCommandSetSpawnerStatus(true,true)
	UAP8Attack:AddCommandLuaFunc(ResetCurrentBridge,true)
end

function ResetCurrentBridge(self)
	self.CurrentBridge = 0
	return true
end

function CheckNextBridgeUA(self)
	if self:GetSize(true,false) <= 0 then
		return true
	end
	if not self:IsIdle() then
		return false
	end
	local _bridgePos = GetPosition("Bridge"..(self.CurrentBridge + 1))
	local count, BridgeId = Logic.GetEntitiesInArea((self.CurrentBridge + 1 == 2 and Entities.PB_Bridge1) or Entities.PB_Bridge2, _bridgePos.X, _bridgePos.Y, 1000, 1)
	if BridgeId ~= 0 and Logic.IsConstructionComplete(BridgeId) == 1 then
		
		self.CurrentBridge = self.CurrentBridge + 1
		return RekursionBridgePoints(self,self.CurrentBridge,5)
	else
		return false
	end
end

function RekursionBridgePoints(self,_bridgeNumber, _numberPoint)
	if _numberPoint < 1 then
		return true
	end
	if IsValid("ArmyMovePos".._bridgeNumber.."_".._numberPoint) then
		table.insert(self.CommandQueue,2, UnlimitedArmy.CreateCommandWaitForIdle(false))
		table.insert(self.CommandQueue,2, UnlimitedArmy.CreateCommandMove(GetPosition("ArmyMovePos".._bridgeNumber.."_".._numberPoint),false))
		table.insert(self.CommandQueue,2, UnlimitedArmy.CreateCommandWaitForIdle(false))
	end
	return RekursionBridgePoints(self,_bridgeNumber, _numberPoint-1)
end